int2 TextureSize;
static int2 SampleSize = ceil(TextureSize / 32.0);

sampler2D Tex0 : register( s0 );

struct VERTEX
{
	float4 Position : POSITION;
	float2 TexCoord : TEXCOORD0;
};

VERTEX vs_main(in VERTEX In)
{
	VERTEX Out;
	Out.Position = In.Position;
	Out.TexCoord = In.TexCoord;
	return Out;
}

float4 ps_minalpha(in VERTEX In) : COLOR
{
	float alpha = 1;
	for(int i = 0; i < SampleSize.x; i++)
	{
		for(int j = 0; j < SampleSize.y; j++)
		{
			float tmp = tex2Dgrad(Tex0, In.TexCoord + float2(i, j) / TextureSize, 0, 0).a;
			alpha = min(alpha, tmp);
		}
	}
	return alpha;
}

technique MinAlpha
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main();
		PixelShader = compile ps_3_0 ps_minalpha();
	}
}